If you are using YEP_OptionsCore.js, you can add a new Option using this
plugin. Here's the following code/parameter settings you can use with it.

---------
Settings:
---------

Name:
\i[302]Synch Monitor FPS

Help Description:
Turn this ON if your monitor runs above 60 FPS
to synchronize the game to run at 60 FPS.

Symbol:
synchFps

Show/Hide:
show = Imported.YEP_SynchFpsOption;

Enable:
enabled = true;

Ext:
ext = 0;

----------
Functions:
----------

Make Option Code:
this.addCommand(name, symbol, enabled, ext);

Draw Option Code:
var rect = this.itemRectForText(index);
var statusWidth = this.statusWidth();
var titleWidth = rect.width - statusWidth;
this.resetTextColor();
this.changePaintOpacity(this.isCommandEnabled(index));
this.drawOptionsName(index);
this.drawOptionsOnOff(index);

Process OK Code:
var index = this.index();
var symbol = this.commandSymbol(index);
var value = this.getConfigValue(symbol);
this.changeValue(symbol, !value);

Cursor Right Code:
var index = this.index();
var symbol = this.commandSymbol(index);
var value = this.getConfigValue(symbol);
this.changeValue(symbol, true);

Cursor Left Code:
var index = this.index();
var symbol = this.commandSymbol(index);
var value = this.getConfigValue(symbol);
this.changeValue(symbol, false);

Default Config Code:
// Empty. Provided by this plugin.

Save Config Code:
// Empty. Provided by this plugin.

Load Config Code:
// Empty. Provided by this plugin.
